# sunrise, sunset + twilights

library("suncalc")
twlg<-getSunlightTimes(date = seq.Date(as.Date("2020-09-15"), as.Date("2020-10-25"), by = 1), lat = 55.1531, lon = 20.8581,
                       keep = c("sunrise", "sunset", "dawn", "dusk", "nauticalDusk", "nauticalDawn"), tz = "UTC-2")
print(twlg)
library("gridExtra")
pdf("data_gridExtra.pdf")       # Export PDF
grid.table(twlg)
dev.off()

library("stargazer")
stargazer(twlg,                 # Export txt
          summary = FALSE,
          type = "text",
          out = "data_stargazer_txt.txt")


#sunrise and sunset
library(StreamMetabolism)
sun           <-sunrise.set(55.1531, 20.8581,"2017/10/13", timezone = "UTC-2", num.days = 20)
sun$date      <-as.POSIXct(paste(sun$sunrise), format="%Y-%m-%d")

# time of moon
library("suncalc")
moontime <-getMoonTimes(date = seq.Date(Sys.Date(), Sys.Date()+30, by = 1),
                        keep = c("rise", "set", "alwaysUp", "alwaysDown"),
                        lat = 55.1531, lon = 20.8581, tz = "UTC-2")