 // библиотека для работы с датчиком освещённости (Troyka-модуль)
#include <TroykaLight.h>

// библиотека для работы с SPI
#include <SPI.h>
// библиотека для работы с SD-картами
#include <SD.h>
// даём разумное имя для CS пина microSD-карты
#define SD_CS_PIN  9
//Подключаем библиотеки для подлючения к WiFi
#include <SPI.h>
#include <WiFiNINA.h>
//Библиотека для связи с облаком ThingSpeak
#include "ThingSpeak.h"
#include "arduino_secrets.h"
// создаём объект для работы с датчиком освещённости
// и передаём ему номер пина выходного сигнала
TroykaLight sensorLight(A0);

// библиотека для работы с метеосенсором
#include <TroykaMeteoSensor.h>
 
// создаём объект для работы с датчиком
TroykaMeteoSensor meteoSensor;

// Добавляем датчик реального времени 
#include <TimeLib.h>
#include <DS1307RTC.h>
#include <Wire.h>
#include <EEPROM.h>

const char *monthName[12] = {
  "Jan", "Feb", "Mar", "Apr", "May", "Jun",
  "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};

tmElements_t tm;
char compileTime[] = __TIME__;
//Информация о WiFi сети

char ssid[] = SECRET_SSID;   // your network SSID (name) 
char pass[] = SECRET_PASS;   // your network password
int keyIndex = 0;            // your network key Index number (needed only for WEP)
WiFiClient  client;

unsigned long myChannelNumber = SECRET_CH_ID;
const char * myWriteAPIKey = SECRET_WRITE_APIKEY;

void setup()
{
  // открываем последовательный порт
  Serial.begin(115200);
    // ждём открытия порта
  while(!Serial) {
  }
  
  bool parse=false;
  bool config=false;
  
  byte hour = getInt(compileTime, 0);
  byte minute = getInt(compileTime, 3);
  byte second = getInt(compileTime, 6);
 
  //Импровизированный хэш времени
  //Содержит в себе количество секунд с начала дня
  unsigned int hash =  hour * 60 * 60 + minute  * 60 + second; 
 
  //Проверяем несовпадение нового хэша с хэшем в EEPROM
  if (EEPROMReadInt(0) != hash) {
 
    //Сохраняем новый хэш
    EEPROMWriteInt(0, hash);
 
    //Готовим для записи в RTC часы, минуты, секунды
    if (getDate(__DATE__) && getTime(__TIME__)) {
    parse = true;
    // and configure the RTC with this info
    if (RTC.write(tm)) {
      config = true;
    }
  }

  }
  
  // get the date and time the compiler was run
  
  // печатаем сообщение об успешной инициализации Serial-порта
  Serial.println("Serial init OK");
  // check for the WiFi module:
  if (WiFi.status() == WL_NO_MODULE) {
    Serial.println("Communication with WiFi module failed!");
    // don't continue
    while (true);
  }

  ThingSpeak.begin(client);  //Initialize ThingSpeak
  
  // начало работы с датчиком
  meteoSensor.begin();
  Serial.println("Meteo Sensor init OK");
  // ждём одну секунду
  delay(1000);
  // выводим сообщение в Serial-порт о поиске карты памяти
  Serial.println("Initializing SD card...");
  // если microSD-карта не была обнаружена
  if (!SD.begin(SD_CS_PIN)) {
    // выводим сообщение об ошибке
    Serial.println("Card failed, or not present");
    // don't do anything more:
    return;
  } else {
    Serial.println("Card initialized.");
  }
}

void loop(){
   // Connect or reconnect to WiFi
  if(WiFi.status() != WL_CONNECTED){
    Serial.print("Attempting to connect to SSID: ");
    Serial.println(SECRET_SSID);
    while(WiFi.status() != WL_CONNECTED){
      WiFi.begin(ssid, pass); // Connect to WPA/WPA2 network. Change this line if using open or WEP network
      Serial.print(".");
      delay(5000);
      } 
    Serial.println("\nConnected.");
  }
  
    if (RTC.read(tm)) {
    Serial.print("Ok, Time = ");
    print2digits(tm.Hour);
    Serial.write(':');
    print2digits(tm.Minute);
    Serial.write(':');
    print2digits(tm.Second);
    Serial.print(", Date (D/M/Y) = ");
    Serial.print(tm.Day);
    Serial.write('/');
    Serial.print(tm.Month);
    Serial.write('/');
    Serial.print(tmYearToCalendar(tm.Year));
    Serial.println();
  } else {
    if (RTC.chipPresent()) {
      Serial.println("The DS1307 is stopped.  Please run the SetTime");
      Serial.println("example to initialize the time and begin running.");
      Serial.println();
    } else {
      Serial.println("DS1307 read error!  Please check the circuitry.");
      Serial.println();
    }
    delay(9000);
  }
  delay(1000);
  
  // считывание данных с датчика освещённости
  sensorLight.read();
  
     Serial.print("Light is ");
  Serial.print(sensorLight.getLightLux());
  Serial.print(" Lx\t");
  
  int stateSensor = meteoSensor.read();
  Serial.print("Temperature = ");
      Serial.print(meteoSensor.getTemperatureC());
      Serial.println(" C \t");
  Serial.print("Humidity = ");
      Serial.print(meteoSensor.getHumidity());
      Serial.println(" %\r\n");
      saveSD();
  // delay(900000);
        // set the fields with the values
  ThingSpeak.setField(1, meteoSensor.getTemperatureC());
  ThingSpeak.setField(2, meteoSensor.getHumidity());
  ThingSpeak.setField(3, sensorLight.getLightLux());
// write to the ThingSpeak channel
  int x = ThingSpeak.writeFields(myChannelNumber, myWriteAPIKey);
  delay(18000000);
}

void logDateTime(File dataFile) {
  
  if (RTC.read(tm)) {
    // дата и время вместе
    print2digitsFile(tm.Hour, dataFile);
    dataFile.write(':');
    print2digitsFile(tm.Minute, dataFile);
    dataFile.write(':');
    print2digitsFile(tm.Second, dataFile);
    dataFile.write(' ');
    dataFile.print(tm.Day);
    dataFile.write('/');
    dataFile.print(tm.Month);
    dataFile.write('/');
    dataFile.print(tmYearToCalendar(tm.Year));
    dataFile.print(',');
    // Отдельно время
    print2digitsFile(tm.Hour, dataFile);
    dataFile.write(':');
    print2digitsFile(tm.Minute, dataFile);
    dataFile.write(':');
    print2digitsFile(tm.Second, dataFile);
    dataFile.print(',');
    // отдельно дата
    dataFile.print(tm.Day);
    dataFile.write('/');
    dataFile.print(tm.Month);
    dataFile.write('/');
    dataFile.print(tmYearToCalendar(tm.Year));
    dataFile.print(',');
    
  } else {
    if (RTC.chipPresent()) {
      Serial.println("The DS1307 is stopped.  Please run the SetTime");
      Serial.println("example to initialize the time and begin running.");
      Serial.println();
    } else {
      Serial.println("DS1307 read error!  Please check the circuitry.");
      Serial.println();
    }
  }
}

void saveSD()
{
  // создаём файл для записи
  File dataFile = SD.open("lux.csv", FILE_WRITE);
  // если файл доступен для записи
  if (dataFile) {
    // запишем время
    logDateTime(dataFile);
    // сохраняем данные
    dataFile.print(sensorLight.getLightLux());
    dataFile.print('\n'); //new row
    // закрываем файл
    dataFile.close();
    // выводим сообщение об удачной записи
    Serial.println("Save OK");
  } else {
    // если файл не доступен
    Serial.println("Error opening lux.csv");
  }
  delay(1000);
  dataFile = SD.open("temp.csv", FILE_WRITE);
  // если файл доступен для записи
  if (dataFile) {
    logDateTime(dataFile);
    // сохраняем данные
    dataFile.print(meteoSensor.getTemperatureC());
    dataFile.print('\n'); //new row
    // закрываем файл
    dataFile.close();
    // выводим сообщение об удачной записи
    Serial.println("Save OK");
  } else {
    // если файл не доступен
    Serial.println("Error opening temp.csv");
  }
  delay(1000);
  
File SdFile = SD.open("humid.csv", FILE_WRITE);
  // если файл доступен для записи
  if (SdFile) {
    logDateTime(SdFile);
    // сохраняем данные
   SdFile.print(meteoSensor.getHumidity());
    SdFile.print('\n'); //new row
    // закрываем файл
    SdFile.close();
    // выводим сообщение об удачной записи
    Serial.println("Save OK");
  } else {
    // если файл не доступен
    Serial.println("Error opening humid.csv");
  }
  delay(1000);
  
dataFile = SD.open("ALLDATA.csv", FILE_WRITE);
    if (dataFile) {
    // сохраняем данные
    logDateTime(dataFile);
    // сохраняем данные
    dataFile.print(sensorLight.getLightLux());
    dataFile.print(','); //new row
      
    dataFile.print(meteoSensor.getTemperatureC());
    dataFile.print(','); //new row
      
    dataFile.print(meteoSensor.getHumidity());
    dataFile.print('\n'); //new row
    // закрываем файл
    dataFile.close();
    // выводим сообщение об удачной записи
    Serial.println("Save All Data OK");
  } else {
    // если файл не доступен
    Serial.println("Error opening allData.csv");
  }
  delay(1000);
}

bool getTime(const char *str)
{
  int Hour, Min, Sec;

  if (sscanf(str, "%d:%d:%d", &Hour, &Min, &Sec) != 3) return false;
  tm.Hour = Hour;
  tm.Minute = Min;
  tm.Second = Sec;
  return true;
}

bool getDate(const char *str)
{
  char Month[12];
  int Day, Year;
  uint8_t monthIndex;

  if (sscanf(str, "%s %d %d", Month, &Day, &Year) != 3) return false;
  for (monthIndex = 0; monthIndex < 12; monthIndex++) {
    if (strcmp(Month, monthName[monthIndex]) == 0) break;
  }
  if (monthIndex >= 12) return false;
  tm.Day = Day;
  tm.Month = monthIndex + 1;
  tm.Year = CalendarYrToTm(Year);
  return true;
}

void print2digits(int number) {
  if (number >= 0 && number < 10) {
    Serial.write('0');
  }
  Serial.print(number);
}
    
void print2digitsFile(int number, File buffer) {
  if (number >= 0 && number < 10) {
    buffer.write('0');
  }
  buffer.print(number);
}

char getInt(const char* string, int startIndex) {
  return int(string[startIndex] - '0') * 10 + int(string[startIndex+1]) - '0';
}
 
//Запись двухбайтового числа в память
void EEPROMWriteInt(int address, int value)
{
  EEPROM.write(address, lowByte(value));
  EEPROM.write(address + 1, highByte(value));
}
 
//Чтение числа из памяти
unsigned int EEPROMReadInt(int address)
{
  byte lowByte = EEPROM.read(address);
  byte highByte = EEPROM.read(address + 1);
 
  return (highByte << 8) | lowByte;
}
