import os
import ffmpeg

def convert_h264_to_mp4(input_file, output_file):
    print(f"Converting {input_file} to {output_file}")
    try:
        ffmpeg.input(input_file).output(output_file).run()
        print(f"Conversion successful: {output_file}")
    except ffmpeg.Error as e:
        print(f"An error occurred during conversion: {e}")
        print(e.stderr.decode())

def convert_all_videos_in_folder(input_folder, output_folder):
    if not os.path.exists(output_folder):
        os.makedirs(output_folder)
        print(f"Created output folder: {output_folder}")

    for filename in os.listdir(input_folder):
        if filename.endswith(".h264"):
            input_file = os.path.join(input_folder, filename)
            output_file = os.path.join(output_folder, os.path.splitext(filename)[0] + ".mp4")
            convert_h264_to_mp4(input_file, output_file)
        else:
            print(f"Skipping non-H264 file: {filename}")

if __name__ == "__main__":
    input_folder = 'C:\\Users\\sasha\\Desktop\\MagLed_25092024'  # Replace with your input folder path
    output_folder = 'C:\\Users\\sasha\\Desktop\\MagLed_25092024'  # Replace with your output folder path

    if os.path.exists(input_folder):
        print(f"Processing files in folder: {input_folder}")
        convert_all_videos_in_folder(input_folder, output_folder)
    else:
        print(f"Input folder does not exist: {input_folder}")
